#ifndef __CClassManager__
#define __CClassManager__

//	===========================================================================

/**
 * @cond
 */
#ifndef __CCLASSMANAGER_DEF__
#define __CCLASSMANAGER_DEF__
namespace Exponent { namespace IO { class CTextStream; } }
namespace Exponent { namespace Basics { class CClass; } }
namespace Exponent { namespace Collections { template<class TypeName> class TPointerCollection; } }
namespace Exponent { namespace Collections { template<class TypeName> class TObjectNuller; } }
using Exponent::Basics::CClass;
using Exponent::IO::CTextStream;
using Exponent::Collections::TPointerCollection;
using Exponent::Collections::TObjectNuller;

#ifndef WIN32
	#ifndef _cdecl
		#define _cdecl
	#endif
#endif

#endif __CCLASSMANAGER_DEF__

// Uncomment the code below, or define it somewhere to turn on full logging
//#define FULL_CLASS_LOGGING
/**
 * @endcond
 */

//	===========================================================================
namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CClassManager CClassManager.hpp
		 * @brief Stores global class information
		 *
		 * CClassManager stores information about all of the classes setup on the system. It can log the instance count\n
		 * and other information about the class directory structure\n
		 * It exists statically as a static part of the CClass class, and should <B>only</B> be accessed through that
		 *
		 * @date 24/06/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CClassManager.hpp,v 1.7 2007/02/11 02:15:54 paul Exp $
		 */
		class CClassManager
		{
		public:

//	===========================================================================

			/**
			 * Construction
			 */
			CClassManager();

			/**
			 * Destruction
			 */
			virtual ~CClassManager();

			/**
			 * Register a new class in to the data base
			 * @param theClass The class to register
			 */
			void registerClass(CClass *theClass);

			/**
			 * Check if a class is actually registered
			 * @param theClass The class to check if registered
			 * @retval bool True if class is registered, false otherwise
			 */
			bool isClassRegistered(const CClass &theClass) const;

			/**
			 * Get an object class given a name
			 * @param name The name of the class
			 * @retval CClass* The class or NULL on error. <B>Never, ever</B> delete this class, it is owned by the system
			 * @note This function is not for general usage. Because of the name mangling that can happen, you may not always be guaranteed to be passing in the correct name
			 */
			CClass *getClassWithName(const char *name);

			/**
			 * Stream the class log information out to a disk file
			 * @param stream The stream to use
			 */
			void logClassInformation(CTextStream *stream) const;

			/**
			 * Sort the classes
			 */
			void sortClasses();

//	===========================================================================

		protected:

//	===========================================================================

			/** @cond */
			typedef int (_cdecl classCompareFunction) (const CClass** obj1, const CClass** obj2);
			/** @endcond */

//	===========================================================================

			TPointerCollection<CClass> *m_classes;		/**< Class objects */
			TObjectNuller<CClass> *m_classNuller;		/**< Nulling object */
		};
	}
}
#endif		// End of CClassManager.hpp